using System;
using System.Diagnostics;
using System.IO;
using System.Security;
using System.Security.Permissions;
using System.Security.Principal;
using System.Security.Cryptography;
using System.Security.AccessControl;
using System.Text;
using System.Collections;
using System.IO.IsolatedStorage;
using System.Xml;
using System.Text.RegularExpressions;
using System.Net;
using System.Net.Sockets;
using System.Runtime.InteropServices;
using System.Web.Configuration;
using System.Configuration;
using System.Security.Policy;
using System.Reflection;
using System.Runtime.Serialization;
using Microsoft.Win32;



namespace CSharpRecipes
{
	public class Security
    {
        #region 17.1 Kontrola dostpu do typw w podzespole lokalnym
        public static void ControlAccess()
        {
            // utworzenie poredniczcego obiektu zabezpieczajcego
            CompanyDataSecProxy companyDataSecProxy = new CompanyDataSecProxy();

            // wczytanie przykadowych danych
            Console.WriteLine("Telefon do szefa: " + 
                companyDataSecProxy.CEOPhoneNumExt);

            // przykadowe dane
            companyDataSecProxy.AdminPwd = "asdf";
            companyDataSecProxy.AdminUserName = "asdf";

            // zapisanie i odwieenie danych
            companyDataSecProxy.SaveNewData();
            companyDataSecProxy.RefreshData();


            // bezporednie utworzenie egzemplarza obiektu CompanyData,
            // bez obiektu poredniczcego
            CompanyData companyData = new CompanyData();

            // wczytanie przykadowych danych
            Console.WriteLine("Telefon do szefa: " + companyData.CEOPhoneNumExt);

            // przykadowe dane
            companyData.AdminPwd = "asdf";
            companyData.AdminUserName = "asdf";

            // zapisanie i odwieenie danych
            companyData.SaveNewData();
            companyData.RefreshData();

        }

        internal interface ICompanyData
        {
            string AdminUserName
            {
                get;
                set;
            }

            string AdminPwd
            {
                get;
                set;
            }

            string CEOPhoneNumExt
            {
                get;
                set;
            }

            void RefreshData();
            void SaveNewData();
        }

        internal class CompanyData : ICompanyData
        {
            public CompanyData()
            {
                Console.WriteLine("[ZABEZPIECZONE] Utworzono obiekt CompanyData");
                // wykonanie kosztownej inicjalizacji
            }

            private string adminUserName = "admin";
            private string adminPwd = "haso";
            private string ceoPhoneNumExt = "0000";

            public string AdminUserName
            {
                get {return (adminUserName);}
                set {adminUserName = value;}
            }
    
            public string AdminPwd
            {
                get {return (adminPwd);}
                set {adminPwd = value;}
            }

            public string CEOPhoneNumExt
            {
                get {return (ceoPhoneNumExt);}
                set {ceoPhoneNumExt = value;}
            }

            public void RefreshData()
            {
                Console.WriteLine("[ZABEZPIECZONE] Dane odwieone");
            }

            public void SaveNewData()
            {
                Console.WriteLine("[ZABEZPIECZONE] Dane zapisane");
            }
        }

        public class CompanyDataSecProxy : ICompanyData
        {
            public CompanyDataSecProxy()
            {
                Console.WriteLine("[ZABEZPIECZAJCYPROXY] Utworzony");

                // najpierw trzeba ustawi gwn polityk
                AppDomain.CurrentDomain.SetPrincipalPolicy(PrincipalPolicy.WindowsPrincipal);
            }


            private ICompanyData coData = null;
            private PrincipalPermission admPerm = 
                new PrincipalPermission(null, @"BUILTIN\Administrators", true);
            private PrincipalPermission guestPerm = 
                new PrincipalPermission(null, @"BUILTIN\Guest", true);
            private PrincipalPermission powerPerm = 
                new PrincipalPermission(null, @"BUILTIN\PowerUser", true);
            private PrincipalPermission userPerm = 
                new PrincipalPermission(null, @"BUILTIN\User ", true);

            public string AdminUserName
            {
                get 
                {
                    string userName = "";
                    try
                    {
                        admPerm.Demand();
                        Startup();
                        userName = coData.AdminUserName;
                    }
                    catch(SecurityException e)
                    {
                        Console.WriteLine("AdminUserName_get nie powiodo si! {0}",e.ToString());
                    }
                    return (userName);
                }
                set 
                {
                    try
                    {
                        admPerm.Demand();
                        Startup();
                        coData.AdminUserName = value;
                    }
                    catch(SecurityException e)
                    {
                        Console.WriteLine("AdminUserName_set nie powiodo si! {0}", e.ToString());
                    }
                }
            }

            public string AdminPwd
            {
                get 
                {
                    string pwd = "";
                    try
                    {
                        admPerm.Demand();
                        Startup();
                        pwd = coData.AdminPwd;
                    }
                    catch(SecurityException e)
                    {
                        Console.WriteLine("AdminPwd_get nie powiodo si! {0}", e.ToString());
                    }

                    return (pwd);
                }
                set 
                {
                    try
                    {
                        admPerm.Demand();
                        Startup();
                        coData.AdminPwd = value;
                    }
                    catch(SecurityException e)
                    {
                        Console.WriteLine("AdminPwd_set nie powiodo si! {0}", e.ToString());
                    }
                }
            }



            public string CEOPhoneNumExt
            {
                get 
                {
                    string ceoPhoneNum = "";
                    try
                    {
                        admPerm.Union(powerPerm).Demand();
                        Startup();
                        ceoPhoneNum = coData.CEOPhoneNumExt;
                    }
                    catch(SecurityException e)
                    {
                        Console.WriteLine("CEOPhoneNum_set nie powiodo si! {0}", e.ToString());
                    }
                    return (ceoPhoneNum);
                }
                set 
                {
                    try
                    {
                        admPerm.Demand();
                        Startup();
                        coData.CEOPhoneNumExt = value;
                    }
                    catch(SecurityException e)
                    {
                        Console.WriteLine("CEOPhoneNum_set nie powiodo si! {0}", e.ToString());
                    }
                }
            }

            public void RefreshData()
            {
                try
                {
                    admPerm.Union(powerPerm.Union(userPerm)).Demand();
                    Startup();
                    Console.WriteLine("[ZABEZPIECZAJCYPROXY] Dane odwieone");
                    coData.RefreshData();
                }
                catch(SecurityException e)
                {
                    Console.WriteLine("RefreshData nie powiodo si! {0}", e.ToString());
                }
            }

            public void SaveNewData()
            {
                try 
                {
                    admPerm.Union(powerPerm).Demand();
                    Startup();
                    Console.WriteLine("[ZABEZPIECZAJCYPROXY] Dane zapisane");
                    coData.SaveNewData();
                }
                catch(SecurityException e)
                {
                    Console.WriteLine("SaveNewData nie powiodo si! {0}", e.ToString());
                }
            }

            // TRZEBA uy [#define DOTRACE], aby kontrolowa monitorujcy proxy
            private void Startup()
            {
                if (coData == null)
                {
                    #if (DOTRACE)
                        coData = new CompanyDataTraceProxy();
                    #else
                        coData = new CompanyData();
                    #endif
                        Console.WriteLine("[ZABEZPIECZAJCYPROXY] Dane odwieone");
                    coData.RefreshData();
                }
            }

            public class CompanyDataTraceProxy : ICompanyData
            {
                public CompanyDataTraceProxy()
                {
                    Console.WriteLine("[MONITORUJCYPROXY] Utworzony");
                    string path = Path.GetTempPath() + @"\CompanyAccessTraceFile.txt";
                    fileStream = new FileStream(path, FileMode.Append, 
                        FileAccess.Write, FileShare.None);
                    traceWriter = new StreamWriter(fileStream);
                    coData = new CompanyData();
                }

                private ICompanyData coData = null;
                private FileStream fileStream = null;
                private StreamWriter traceWriter = null;


                public string AdminPwd
                {
                    get 
                    {
                        traceWriter.WriteLine("Haso administratora przeczytane przez uytkownika.");
                        traceWriter.Flush();
                        return (coData.AdminPwd);
                    }
                    set
                    {
                        traceWriter.WriteLine("Haso administratora zapisane przez uytkownika.");
                        traceWriter.Flush();
                        coData.AdminPwd = value;
                    }
                }

                public string AdminUserName
                {
                    get 
                    {
                        traceWriter.WriteLine("Nazwa uytkownika administratora przeczytana przez uytkownika.");
                        traceWriter.Flush();
                        return (coData.AdminUserName);
                    }
                    set
                    {
                        traceWriter.WriteLine("Nazwa uytkownika administratora zapisana przez uytkownika.");
                        traceWriter.Flush();
                        coData.AdminUserName = value;
                    }
                }

                public string CEOPhoneNumExt
                {
                    get 
                    {
                        traceWriter.WriteLine("Telefon do szefa przeczytany przez uytkownika.");
                        traceWriter.Flush();
                        return (coData.CEOPhoneNumExt);
                    }
                    set
                    {
                        traceWriter.WriteLine("Telefon do szefa zapisany przez uytkownika.");
                        traceWriter.Flush();
                        coData.CEOPhoneNumExt = value;
                    }
                }

                public void RefreshData()
                {
                    Console.WriteLine("[MONITORUJCYPROXY] Dane odwieone");
                    coData.RefreshData();
                }

                public void SaveNewData()
                {
                    Console.WriteLine("[MONITORUJCYPROXY] Dane zapisane");
                    coData.SaveNewData();
                }
            }

        }

        #endregion

        #region 17.2 Szyfrowanie i rozszyfrowywanie cigu znakw
        public static void EncDecString()
        {
            string encryptedString = CryptoString.Encrypt("MojeHaso");
            Console.WriteLine("Zaszyfrowany cig znakw: " + encryptedString);
            // odczytanie uytego klucza i wektora IV, aby mc pniej rozszyfrowa cig
            byte [] key = CryptoString.Key;
            byte [] IV = CryptoString.IV;

            CryptoString.Key = key;
            CryptoString.IV = IV;
            string decryptedString = CryptoString.Decrypt(encryptedString);
            Console.WriteLine("Odszyfrowany cig znakw: " + decryptedString);

        }

        public sealed class CryptoString
        {
            private CryptoString() {}

            private static byte[] savedKey = null;
            private static byte[] savedIV = null;

            public static byte[] Key
            {
                get { return savedKey; }
                set { savedKey = value; }
            }

            public static byte[] IV
            {
                get { return savedIV; }
                set { savedIV = value; }
            }

            private static void RdGenerateSecretKey(RijndaelManaged rdProvider)
            {
                if (savedKey == null)
                {
                    rdProvider.KeySize = 256;
                    rdProvider.GenerateKey();
                    savedKey = rdProvider.Key;
                }
            }

            private static void RdGenerateSecretInitVector(RijndaelManaged rdProvider)
            {
                if (savedIV == null)
                {
                    rdProvider.GenerateIV();
                    savedIV = rdProvider.IV;
                }
            }

            public static string Encrypt(string originalStr)
            {
                // zakodowanie cigu znakw, aby zapisa go w pamici
                byte[] originalStrAsBytes = Encoding.ASCII.GetBytes(originalStr);
                byte[] originalBytes = {};

                // utworzenie strumienia MemoryStream zawierajcego dane wynikowe
                MemoryStream memStream = new MemoryStream(originalStrAsBytes.Length);

                RijndaelManaged rijndael = new RijndaelManaged();

                // wygenerowanie i zapisanie klucza i wektora inicjujcego
                RdGenerateSecretKey(rijndael);
                RdGenerateSecretInitVector(rijndael);

                if (savedKey == null || savedIV == null)
                {
                    throw (new NullReferenceException(
                        "Klucz savedKey oraz wektor inicjujcy savedIV nie mog by puste."));
                }

                // utworzenie obiektw szyfrujcego i strumienia
                ICryptoTransform rdTransform = 
                    rijndael.CreateEncryptor((byte[])savedKey.Clone(),
                                            (byte[])savedIV.Clone());
                CryptoStream cryptoStream = new CryptoStream(memStream, rdTransform, 
                    CryptoStreamMode.Write);

                // zapisanie zaszyfrowanych danych do strumienia MemoryStream
                cryptoStream.Write(originalStrAsBytes, 0, originalStrAsBytes.Length);
                cryptoStream.FlushFinalBlock();
                originalBytes = memStream.ToArray();

                // zwolnienie wszystkich zasobw
                memStream.Close();
                cryptoStream.Close();
                rdTransform.Dispose();
                rijndael.Clear();

                // konwersja zaszyfrowanego cigu znakw
                string encryptedStr = Convert.ToBase64String(originalBytes);
                return (encryptedStr);
            }

            public static string Decrypt(string encryptedStr)
            {
                // zdekodowanie zaszyfrowanego cigu znakw
                byte[] encryptedStrAsBytes = Convert.FromBase64String(encryptedStr);
                byte[] initialText = new Byte[encryptedStrAsBytes.Length];

                RijndaelManaged rijndael = new RijndaelManaged();
                MemoryStream memStream = new MemoryStream(encryptedStrAsBytes);

                if (savedKey == null || savedIV == null)
                {
                    throw (new NullReferenceException(
                        "Klucz savedKey oraz wektor inicjujcy savedIV nie mog by puste."));
                }

                // utworzenie obiektw szyfrujcego i strumienia
                ICryptoTransform rdTransform = 
                    rijndael.CreateDecryptor((byte[])savedKey.Clone(), 
                                            (byte[])savedIV.Clone());
                CryptoStream cryptoStream = new CryptoStream(memStream, rdTransform, 
                    CryptoStreamMode.Read);

                // wczytanie zaszyfrowanego cigu znakw jako tablicy byte[]
                cryptoStream.Read(initialText, 0, initialText.Length);

                // zwolnienie wszystkich zasobw
                memStream.Close();
                cryptoStream.Close();
                rdTransform.Dispose();
                rijndael.Clear();

                // przeksztacenie tablicy byte[] do postaci cigu znakw
                string decryptedStr = Encoding.ASCII.GetString(initialText);
                return (decryptedStr);
            }
        }

        #endregion

        #region 17.3 Szyfrowanie i rozszyfrowywanie pliku
        public static void EncDecFile()
        {
            // uycie algorytmu TripleDES
            using (TripleDESCryptoServiceProvider tdes = new TripleDESCryptoServiceProvider())
            {
                SecretFile secretTDESFile = new SecretFile(tdes, "tdestext.secret");

                string encrypt = "Moje sekretne dane TDES!";

                Console.WriteLine("Zapisywanie sekretnych danych: {0}", encrypt);
                secretTDESFile.SaveSensitiveData(encrypt);
                // zapisanie wartoci, by odczyta plik
                byte[] key = secretTDESFile.Key;
                byte[] IV = secretTDESFile.IV;

                string decrypt = secretTDESFile.ReadSensitiveData();
                Console.WriteLine("Odczytanie sekretnych danych: {0}", decrypt);
            }

            // uycie algorytmu Rijndael
            using (RijndaelManaged rdProvider = new RijndaelManaged())
            {
                SecretFile secretRDFile = new SecretFile(rdProvider, "rdtext.secret");

                string encrypt = "Moje sekretne dane Rijndael!";

                Console.WriteLine("Zapisywanie sekretnych danych: {0}", encrypt);
                secretRDFile.SaveSensitiveData(encrypt);
                // zapisanie wartoci, by odczyta plik
                byte[] key = secretRDFile.Key;
                byte[] IV = secretRDFile.IV;

                string decrypt = secretRDFile.ReadSensitiveData();
                Console.WriteLine("Odczytanie sekretnych danych: {0}", decrypt);
            }

        }

        public class SecretFile
        {
            private byte[] savedKey = null;
            private byte[] savedIV = null;
            private SymmetricAlgorithm symmetricAlgorithm;
            string path;

            public byte[] Key
            {
                get { return savedKey; }
                set { savedKey = value; }
            }

            public byte[] IV
            {
                get { return savedIV; }
                set { savedIV = value; }
            }

            public SecretFile(SymmetricAlgorithm algorithm, string fileName)
            {
                symmetricAlgorithm = algorithm;
                path = fileName;
            }

            public void SaveSensitiveData(string sensitiveData)
            {
                // zakodowanie cigu znakw, ktry zostanie zapisany w zaszyfrowanym pliku
                byte[] encodedData = Encoding.Unicode.GetBytes(sensitiveData);

                // utworzenie strumienia FileStream i obiektw szyfrujcych
                using (FileStream fileStream = new FileStream(path,
                       FileMode.Create,
                       FileAccess.Write))
                {
                    // wygenerowanie i zapisanie klucza i wektora inicjujcego
                    GenerateSecretKey();
                    GenerateSecretInitVector();

                    // utworzenie obiektw transformacji i strumienia
                    using (ICryptoTransform transform = symmetricAlgorithm.CreateEncryptor(savedKey,
                        savedIV))
                    {
                        using (CryptoStream cryptoStream =
                            new CryptoStream(fileStream, transform, CryptoStreamMode.Write))
                        {

                            // zapisanie zaszyfrowanych danych w pliku
                            cryptoStream.Write(encodedData, 0, encodedData.Length);
                        }

                    }
                }
            }

            public string ReadSensitiveData()
            {
                string decrypted = "";
                // utworzenie strumienia pliku, by z powrotem odczyta zaszyfrowany pliku
                using (FileStream fileStream = new FileStream(path,
                    FileMode.Open,
                    FileAccess.Read))
                {
                    // wywietlenie zawartoci zaszyfrowanego pliku
                    using (BinaryReader binReader = new BinaryReader(fileStream))
                    {
                        Console.WriteLine("---------- Dane zaszyfrowane ---------");
                        int count = (Convert.ToInt32(binReader.BaseStream.Length));
                        byte[] bytes = binReader.ReadBytes(count);
                        char[] array = Encoding.Unicode.GetChars(bytes);
                        string encdata = new string(array);
                        Console.WriteLine(encdata);
                        Console.WriteLine("---------- Dane zaszyfrowane ---------\r\n");

                        // zresetowanie strumienia pliku
                        fileStream.Seek(0, SeekOrigin.Begin);

                        // utworzenie obiektu rozszyfrowujcego
                        using (ICryptoTransform transform = symmetricAlgorithm.CreateDecryptor(savedKey,
                            savedIV))
                        {
                            using (CryptoStream cryptoStream = new CryptoStream(fileStream,
                                transform,
                                CryptoStreamMode.Read))
                            {

                                // wywietlenie zawartoci rozszyfrowanego pliku
                                StreamReader srDecrypted = new StreamReader(cryptoStream,
                                    new UnicodeEncoding());
                                Console.WriteLine("---------- Dane rozszyfrowane ---------");
                                decrypted = srDecrypted.ReadToEnd();
                                Console.WriteLine(decrypted);
                                Console.WriteLine("---------- Dane rozszyfrowane ---------");
                            }
                        }
                    }
                }

                return decrypted;
            }

            private void GenerateSecretKey()
            {
                if(null != (symmetricAlgorithm as TripleDESCryptoServiceProvider))
                {
                    TripleDESCryptoServiceProvider tdes;
                    tdes = symmetricAlgorithm as TripleDESCryptoServiceProvider;
                    tdes.KeySize = 192; //  maksymalny rozmiar klucza
                    tdes.GenerateKey();
                    savedKey = tdes.Key;
                }
                else if(null != (symmetricAlgorithm as RijndaelManaged))
                {
                    RijndaelManaged rdProvider;
                    rdProvider = symmetricAlgorithm as RijndaelManaged;
                    rdProvider.KeySize = 256; // maksymalny rozmiar klucza
                    rdProvider.GenerateKey();
                    savedKey = rdProvider.Key;
                }
            }

            private void GenerateSecretInitVector()
            {
                if(null != (symmetricAlgorithm as TripleDESCryptoServiceProvider))
                {
                    TripleDESCryptoServiceProvider tdes;
                    tdes = symmetricAlgorithm as TripleDESCryptoServiceProvider;
                    tdes.GenerateIV();
                    savedIV = tdes.IV;
                }
                else if(null != (symmetricAlgorithm as RijndaelManaged))
                {
                    RijndaelManaged rdProvider;
                    rdProvider = symmetricAlgorithm as RijndaelManaged;
                    rdProvider.GenerateIV();
                    savedIV = rdProvider.IV;
                }
            }
        }

        #endregion

        #region 17.4 Usuwanie danych dotyczcych szyfrowania
        public static void CleanUpCrypto()
        {
            string originalStr = "Nadzwyczaj tajne informacje";
            // zakodowanie cigu znakw w celu zapisania go w pamici
            byte[] originalStrAsBytes = Encoding.ASCII.GetBytes(originalStr);
            byte[] originalBytes = {};

            // utworzenie strumienia MemoryStream, ktry bdzie zawiera dane wynikowe
            MemoryStream memStream = new MemoryStream(originalStrAsBytes.Length);

            RijndaelManaged rijndael = new RijndaelManaged();

            // wygenerowanie klucza oraz wektora inicjujcego
            rijndael.KeySize = 256;
            rijndael.GenerateKey();
            rijndael.GenerateIV();

            // zapisanie klucza i wektora inicjujcego dla celw pniejszego rozszyfrowywania
            byte [] key = rijndael.Key;
            byte [] IV = rijndael.IV;

            // utworzenie obiektu szyfrujcego i strumienia
            ICryptoTransform transform = rijndael.CreateEncryptor(rijndael.Key,
                rijndael.IV);
            CryptoStream cryptoStream = new CryptoStream(memStream, transform, 
                CryptoStreamMode.Write);

            // zapisanie zaszyfrowanych danych do strumienia MemoryStream
            cryptoStream.Write(originalStrAsBytes, 0, originalStrAsBytes.Length);
            cryptoStream.FlushFinalBlock();

            // zwolnienie wszystkich zasobw zaraz po ich wykorzystaniu,
            // aby zapobiec pozostaniu jakichkolwiek danych w pamici
            memStream.Close();
            memStream = null;
            cryptoStream.Close();
            cryptoStream = null;
            transform.Dispose();
            transform = null;
            // instrukcja Clear ponownie inicjuje klucz i wektor,
            // aby w pamici przestay by dostpne dane wykorzystane w trakcie szyfrowania
            rijndael.Clear();
            // niezwoczne ponowne udostpnienie dla GC
            rijndael = null;
        }
        #endregion

        #region 17.5 Sprawdzenie, czy cig znakw nie uleg uszkodzeniu w trakcie transmisji
        public static void VerifyNonStringCorruption()
        {
            string testString = "To jest sprawdzany cig znakw.";            
            string unhashedString;
            string hashedString = HashOps.CreateStringHash(testString);

            bool result = HashOps.TestReceivedStringHash(hashedString, out unhashedString);
            Console.WriteLine(result);
            if (!result)
                Console.WriteLine("Wysano nastpujcy cig znakw: " + unhashedString);
            else
                Console.WriteLine("Cig znakw " + unhashedString + 
                    " uleg uszkodzeniu.");
        }

        public class HashOps
        {
            // liczba 44 to dugo reprezentacji base64 wartoci mieszajcej,
            // ktra zostanie doczona do cigu znakw
            private const int HASH_LENGTH = 44;
            public static string CreateStringHash(string unHashedString)
            {
                byte[] encodedUnHashedString = Encoding.Unicode.GetBytes(unHashedString);
                string stringWithHash = "";

                using (SHA256Managed hashingObj = new SHA256Managed())
                {
                    byte[] hashCode = hashingObj.ComputeHash(encodedUnHashedString);

                    string hashBase64 = Convert.ToBase64String(hashCode);
                    stringWithHash = unHashedString + hashBase64;
                }               

                return (stringWithHash);
            }

            public static bool TestReceivedStringHash(string stringWithHash, 
                out string originalStr)
            {
                // kod, ktry szybko sprawdza obsug zmienionego cigu znakw
                 stringWithHash = stringWithHash.Replace('a', 'b');

                if (stringWithHash.Length < HASH_LENGTH)
                {
                    originalStr = null;
                    return (true);
                }

                string hashCodeString =
                    stringWithHash.Substring(stringWithHash.Length - HASH_LENGTH);
                string unHashedString =
                    stringWithHash.Substring(0, stringWithHash.Length - HASH_LENGTH);

                byte[] hashCode = Convert.FromBase64String(hashCodeString);

                byte[] encodedUnHashedString = Encoding.Unicode.GetBytes(unHashedString);

                bool hasBeenTamperedWith = false;
                using (SHA256Managed hashingObj = new SHA256Managed())
                {
                    byte[] receivedHashCode = hashingObj.ComputeHash(encodedUnHashedString);


                    for (int counter = 0; counter < receivedHashCode.Length; counter++)
                    {
                        if (receivedHashCode[counter] != hashCode[counter])
                        {
                            hasBeenTamperedWith = true;
                            break;
                        }
                    }

                    if (!hasBeenTamperedWith)
                    {
                        originalStr = unHashedString;
                    }
                    else
                    {
                        originalStr = null;
                    }
                }

                return (hasBeenTamperedWith);
            }
        }

        #endregion

        #region 17.6 Przesanianie mechanizmu dodajcego warto mieszajc do cigu znakw
        public static void WrappingStringHash()
        {
            StringWriter stringWriter = new StringWriter(new StringBuilder("Tekst pocztkowy"));
            StringWriterHash stringWriterHash = new StringWriterHash();
            stringWriterHash.SetWriter(stringWriter);
            stringWriterHash.Write("-Dodatkowy tekst-");
            stringWriterHash.WriteHash();
            Console.WriteLine("stringWriterHash.ToString(): " + stringWriterHash.ToString());
        }

        [Serializable]
        public abstract class WriterDecorator : TextWriter
        {
            public WriterDecorator() {}

            public WriterDecorator(StringWriter stringWriter)
            {
                internalStringWriter = stringWriter;
            }

            protected bool isHashed = false;
            protected StringWriter internalStringWriter = null;

            public void SetWriter(StringWriter stringWriter)
            {
                internalStringWriter = stringWriter;
            }
        }

        [Serializable]
        public class StringWriterHash : WriterDecorator
        {
            public StringWriterHash() : base() {} 

            public StringWriterHash(StringWriter stringWriter) : base(stringWriter)
            {
            }


            public override Encoding Encoding 
            {
                get {return (internalStringWriter.Encoding);}
            }

            public override void Close()
            {
                internalStringWriter.Close();
                base.Dispose(true);             // zakoczenie czyszczenia
            }

            public override void Flush()
            {
                internalStringWriter.Flush();
                base.Flush();
            }

            public virtual StringBuilder GetStringBuilder()
            {
                return (internalStringWriter.GetStringBuilder());
            }

            public override string ToString()
            {
                return (internalStringWriter.ToString());
            }

            public void WriteHash()
            {
                int originalStrLen = internalStringWriter.GetStringBuilder().Length;

                // wywoanie generatora wartoci mieszajcej dla caego cigu znakw
                string hashedString = HashOps.CreateStringHash(this.ToString());
                internalStringWriter.Write(hashedString.Substring(originalStrLen));

                isHashed = true;
            }

            public override void Write(char value)
            {
                if (isHashed)
                {
                    throw (new Exception("Warto mieszajca zostaa ju dodana do cigu znakw, dlatego nie mona go zmieni."));
                }
                else
                {
                    internalStringWriter.Write(value);
                }
            }

            public override void Write(string value)
            {
                if (isHashed)
                {
                    throw (new Exception("Warto mieszajca zostaa ju dodana do cigu znakw, dlatego nie mona go zmieni."));
                }
                else
                {
                    internalStringWriter.Write(value);
                }
            }

            public override void Write(char[] buffer, int index, int count)
            {
                if (isHashed)
                {
                    throw (new Exception("Warto mieszajca zostaa ju dodana do cigu znakw, dlatego nie mona go zmieni."));
                }
                else
                {
                    internalStringWriter.Write(buffer, index, count);
                }
            }

            protected override void Dispose(bool disposing)
            {
                base.Dispose(disposing);
            }
        }

        [Serializable]
        public abstract class ReaderDecorator : TextReader
        {
            public ReaderDecorator() {}

            public ReaderDecorator(StringReader stringReader)
            {
                internalStringReader = stringReader;
            }

            protected StringReader internalStringReader = null;

            public void SetReader(StringReader stringReader)
            {
                internalStringReader = stringReader;
            }
        }

        [Serializable]
        public class StringReaderHash : ReaderDecorator
        {
            public StringReaderHash() : base() {}

            public StringReaderHash(StringReader stringReader) : base(stringReader)
            {
            }

            public override void Close()
            {
                internalStringReader.Close();
                base.Dispose(true); // zakoczenie czyszczenia
            }

            public string ReadToEndHash()
            {
                string hashStr = internalStringReader.ReadToEnd();

                string originalStr = "";
                // wywoanie obiektu odczytujcego warto mieszajc
                bool isInvalid = HashOps.TestReceivedStringHash(hashStr, 
                    out originalStr);

                if (isInvalid)
                {
                    throw (new Exception("Sprawdzenie wartoci mieszajcej dla cigu znakw nie powiodo si."));
                }

                return (originalStr);
            }

            public override int Read()
            {
                return (internalStringReader.Read());
            }

            public override int Read(char[] buffer, int index, int count)
            {
                return (internalStringReader.Read(buffer, index, count));
            }

            public override string ReadLine()
            {
                return (internalStringReader.ReadLine());
            }

            public override string ReadToEnd()
            {
                return (internalStringReader.ReadToEnd());
            }

            protected override void Dispose(bool disposing)
            {
                base.Dispose(disposing);
            }
        }


        #endregion

        #region 17.7 Ulepszony generator liczb losowych
        public static void BetterRandomString()
        {
            // utworzenie silniejszego kodu mieszajcego przy uyciu RNGCryptoServiceProvider
            byte[] random = new byte[64];
            RNGCryptoServiceProvider rng = new RNGCryptoServiceProvider();
            // wypenienie losowymi bajtami
            rng.GetBytes(random);

            // przeksztacenie losowych bajtw w cig znakw
            string randomBase64 = Convert.ToBase64String(random);
            // wywietlenie cigu znakw
            Console.WriteLine("Losowy cig znakw: {0}\r\n ",randomBase64);
        }

        #endregion

        #region 17.8 Bezpieczne przechowywanie danych
        public static void SecurelyStoringData()
        {
            UserSettings settings = new UserSettings("89734kdkjs8734kjhd");
            if(settings.CheckPassword("89734kdkjs8734kjhd"))
            {
                Console.WriteLine("Witaj");
            }
        }

        // klasa przechowujca ustawienia uytkownika
        public class UserSettings
        {
            IsolatedStorageFileStream isoFileStream = null;
            XmlDocument settingsDoc = null;
            const string storageName = "SettingsStorage.xml";

            // konstruktor
            public UserSettings(string password)
            {
                // utworzenie odizolowanego kontenera
                using (IsolatedStorageFile isoStorageFile = IsolatedStorageFile.GetUserStoreForDomain())
                {
                    // utworzenie wewntrznego DOM dla ustawie
                    settingsDoc = new XmlDocument();
                    // jeli nie ma ustawie utworzenie domylnych
                    if (isoStorageFile.GetFileNames(storageName).Length == 0)
                    {
                        using (IsolatedStorageFileStream isoFileStream =
                            new IsolatedStorageFileStream(storageName,
                            FileMode.Create,
                            isoStorageFile))
                        {

                            using (XmlTextWriter writer = new XmlTextWriter(isoFileStream, Encoding.UTF8))
                            {
                                writer.WriteStartDocument();
                                writer.WriteStartElement("Settings");
                                writer.WriteStartElement("User");
                                // odczytanie biecego uytkownika
                                WindowsIdentity user = WindowsIdentity.GetCurrent();
                                writer.WriteString(user.Name);
                                writer.WriteEndElement();
                                writer.WriteStartElement("Password");
                                // przekazanie null, aby utworzy haso CreateHashPassword
                                string hashedPassword = CreateHashedPassword(password, null);
                                writer.WriteString(hashedPassword);
                                writer.WriteEndElement();
                                writer.WriteEndElement();
                                writer.WriteEndDocument();
                                writer.Flush();
                                writer.Close();
                                Console.WriteLine("Tworzenie ustawie dla " + user.Name);
                            }
                        }
                    }

                    // ustawienie dostpu do kontenera danych
                    using (IsolatedStorageFileStream isoFileStream =
                        new IsolatedStorageFileStream(storageName,
                        FileMode.Open,
                        isoStorageFile))
                    {
                        // zaadowanie ustawie z odizolowanego strumienia pliku
                        settingsDoc.Load(isoFileStream);
                        Console.WriteLine("Zaadowano ustawienia dla " + User);
                    }
                }
            }

            // waciwo User udostpnia tosamo WindowsIdentity uytkownika, do ktrego nale ustawienia

            // waciwo User
            public string User
            {
                get
                {
                    XmlNode userNode = settingsDoc.SelectSingleNode("Settings/User");
                    if(userNode != null)
                    {
                        return userNode.InnerText;
                    }
                    return "";
                }
            }

            // waciwo Password odczytuje zaszyfrowane haso z kontenera XML,
            // a w momencie uaktualnienia hasa odczytuje je w postaci otwartego tekstu
            // i tworzy wersj mieszan i zaszyfrowan, po czym j zapisuje

            // waciwo Password
            public string Password
            {
                get
                {
                    XmlNode pwdNode = 
                        settingsDoc.SelectSingleNode("Settings/Password");
                    if(pwdNode != null)
                    {
                        return pwdNode.InnerText;
                    }
                    return "";
                }
                set
                {
                    XmlNode pwdNode = 
                        settingsDoc.SelectSingleNode("Settings/Password");

                    string hashedPassword = CreateHashedPassword(value,null);
                    if(pwdNode != null)
                    {
                        pwdNode.InnerText = hashedPassword;
                    }
                    else
                    {
                        XmlNode settingsNode = 
                            settingsDoc.SelectSingleNode("Settings");
                        XmlElement pwdElem = 
                            settingsDoc.CreateElement("Password");
                        pwdElem.InnerText=hashedPassword;
                        settingsNode.AppendChild(pwdElem);
                    }
                }
            }

            // Metoda CreateHashedPassword tworzy zaszyfrowane i mieszane haso. Parametr password
            // jest hasem zapisanym otwartym tekstem, za parametr existingSalt to ziarno,
            // kte naley uy w celu utworzenia wersji zaszyfrowanej. 
            // Jeli ziarno nie istnieje, na przykad gdy haso jest zapisywane po raz pierwszy,
            // existingSalt powinno mie warto null - wwczas wygenerowane zostanie ziarno losowe.
            // Gdy ziarno jest ju znane, jest ono czone z hasem i mieszane przy uyciu klasy SHA512Managed.
            // Ziarno jest wczas doklejane na kocu wartoci mieszajcej.
            // Caa warto jest kodowana do postaci base64 i zwracana.
            // Utworzenie mieszanego hasa
            private string CreateHashedPassword(string password, 
                                                byte[] existingSalt)
            {
                byte [] salt = null;
                if(existingSalt == null)
                {
                    // wygenerowanie losowego ziarna
                    Random  random = new Random();
                    int size = random.Next(16, 64);

                    // utworzenie tablicy ziarna
                    salt = new byte[size];

                    // uycie ulepszonego generatora liczb losowych,
                    // aby uzyska bajty ziarna
                    RNGCryptoServiceProvider rng = new RNGCryptoServiceProvider();
                    rng.GetNonZeroBytes(salt); 
                }
                else
                    salt = existingSalt;

                // przeksztacenie cigu znakw w bajty
                byte[] pwd = Encoding.UTF8.GetBytes(password);

                // utworzenie kontenera dla hasa i ziarna
                byte[] saltedPwd = new byte[pwd.Length + salt.Length];

                // najpierw dodanie bajtw hasa
                pwd.CopyTo(saltedPwd,0);
                // dodanie ziarna
                salt.CopyTo(saltedPwd,pwd.Length);

                // uycie SHA512 jako algorytmu mieszajcego
                byte[] hashWithSalt = null;
                using (SHA512Managed sha512 = new SHA512Managed())
                {

                    // odczytanie wartoci mieszajcej dla zaszyfrowanego hasa
                    byte[] hash = sha512.ComputeHash(saltedPwd);

                    // doklejenie ziarna do wartoci mieszajcej
                    hashWithSalt = new byte[hash.Length + salt.Length];

                    // wkopiowanie bajtw
                    hash.CopyTo(hashWithSalt, 0);
                    salt.CopyTo(hashWithSalt, hash.Length);
                }
            
                // zwrcenie wartoci mieszajcej zakodowanej base64 z ziarnem
                return Convert.ToBase64String(hashWithSalt);
            }

            // porwnanie hasa z zawartoci kontenera
            public bool CheckPassword(string password)
            {
                // odczytanie bajtw hasa
                // warto mieszajca dla zaszyfrowanego hasa i ziarna
                byte[] hashWithSalt = Convert.FromBase64String(Password);

                // rozmiar wartoci mieszajcej wynosi 512 bitw (SHA512)
                int hashSizeInBytes = 512 / 8;

                // kontener dla oryginalnego ziarna
                int saltSize = hashWithSalt.Length - hashSizeInBytes;
                byte[] salt = new byte[saltSize];

                // skopiowanie ziarna
                Array.Copy(hashWithSalt,hashSizeInBytes,salt,0,saltSize);

                // ustalenie wartoci mieszajcej dla hasa
                string passwordHash = CreateHashedPassword(password,salt);

                // jeli obliczona warto mieszajca odpowiada wartoci podanej,
                // warto w otwartym tekcie musi by prawidowa
                return (Password == passwordHash);
            }
        }

        #endregion

        #region 17.9 Zabezpieczanie asertacji bezpieczestwa
        public static void SafeAssert()
        {
            CallSecureFunctionSafelyAndEfficiently();
        }

        public static void CallSecureFunctionSafelyAndEfficiently()
        {

            // ustawienie uprawnienia, aby umoliwi dostp
            // do skadowych niepublicznych za porednictwem odzwierciedlania            
            ReflectionPermission perm = 
                new ReflectionPermission(ReflectionPermissionFlag.MemberAccess);

            // Zadanie uprawnienia przed wywoaniem Assert, aby zapewni,
            // e posiadane s odpowiednie prawa. Demand jest wywoywana, by
            // zapewni, e uprawnienia zostay zweryfikowane przed
            // uyciem Assert, dziki czemu zachowane zostanie bezpieczestwo,
            // a take odpowiednia wydajno dziaania.
            perm.Demand();

            // Asertacja prawa przed wywoaniem funkcji, ktra rwnie
            // wywoa Demand, aby skrci przejcie przez stos wykonywane
            // przy kadym wywoaniu. Dziki Assert optymalizowane jest
            // uycie SecureFunction.
            perm.Assert();

            // SecureFunction jest wywoywana 100 razy, lecz przejcie
            // przez stos odbywa si tylko z tej funkcji do funkcji wywoujcej,
            // a nie przez cay stos 100 razy.
            for(int i=0;i<100;i++)
            {
                SecureFunction();
            }
        }

        public static void SecureFunction()
        {
            // ustawienie uprawnienia, aby umoliwi dostp
            // do skadowych niepublicznych za porednictwem odzwierciedlania 
            ReflectionPermission perm = 
                new ReflectionPermission(ReflectionPermissionFlag.MemberAccess);

            // zadanie uprawnienia i wykonanie przejcia przez stos
            perm.Demand();            

            // wykonanie odpowiednich czynnoci...
        }

        #endregion

        #region 17.10 Zapobieganie niepodanym zmianom w podzespole
        public static void PreventMaliciousMods()
        {
            Console.WriteLine("Patrz receptura dotyczca podpisywania podzespow narzdziem SN.exe");
        }
        #endregion

        #region 17.11 Sprawdzanie, czy podzespoowi udzielono odpowiednich uprawnie
        public static void VerifyAssemblyPerms()
        {
            // Ustawienie wyraenia regularnego dla witryny Helion
            // i uycie go do utworzenia uprawnienia WebPermission, aby mc
            // poczy si z witryn oraz wszystkimi witrynami zawierajcymi cig
            // znakw www.helion.pl. Nastpnie naley sprawdzi WebPermission za porednictwem
            // SecurityManager i upewni si, e uprawnienie rzeczywicie zostao udzielone.            
            Regex regex = new Regex(@"http://www\.helion\.pl/.*");
            WebPermission webConnectPerm = new WebPermission(NetworkAccess.Connect,regex);
            if(SecurityManager.IsGranted(webConnectPerm))
            {
                // poczenie z witryn Wydawnictwa Helion
            }
        }
        #endregion

        #region 17.12 Minimalizowanie zakresu uprawnie podzespou umoliwiajcych przeprowadzenie ataku
        public static void MinimizeAttackSurface()
        {
            Console.WriteLine("Patrz receptura dotyczca implementacji SecurityAction.RequestRefuse");
        }
        #endregion

		#region "***       Jak przybra tosamo innego uytkownika (patrz klasa WindowsIdentity)"
		// ms-help://MS.VSCC.v80/MS.MSDNQTR.v80.en/MS.MSDN.v80/MS.NETDEVFX.v20.en/cpref/html/M_System_Security_Principal_WindowsIdentity_Impersonate.htm
		#endregion

        #region 17.13 Uzyskiwanie informacji monitorowania i o zabezpieczeniach
        // ms-help://MS.VSCC.v80/MS.MSDNQTR.v80.en/MS.MSDN.v80/MS.NETDEVFX.v20.en/cpref/html/M_System_Security_AccessControl_ObjectSecurity_GetOwner_1_a6998a77.htm


		public static void TestViewFileRegRights()
		{
			// odczytanie z pliku informacji o zabezpieczeniach
			string file = @"c:\BOOT.INI";
			FileSecurity fileSec = File.GetAccessControl(file);
			DisplayFileSecurityInfo(fileSec);

			// odczytanie informacji o zabezpieczeniach z klucza rejestru
            RegistryKey regKey = Registry.LocalMachine.OpenSubKey(@"SOFTWARE\MojaFirma\MojaAplikacja");
			RegistrySecurity regSecurity = regKey.GetAccessControl();
			DisplayRegKeySecurityInfo(regSecurity);
		}


		public static void DisplayRegKeySecurityInfo(RegistrySecurity regSec)
		{
			Console.WriteLine("GetSecurityDescriptorSddlForm:  " + regSec.GetSecurityDescriptorSddlForm(AccessControlSections.All));

			foreach (RegistryAccessRule ace in regSec.GetAccessRules(true, true, typeof(NTAccount)))
			{
				Console.WriteLine("\tIdentityReference.Value: " + ace.IdentityReference.Value);
				Console.WriteLine("\tAccessControlType: " + ace.AccessControlType);
				Console.WriteLine("\tRegistryRights: " + ace.RegistryRights.ToString());
				Console.WriteLine("\tInheritanceFlags: " + ace.InheritanceFlags);
				Console.WriteLine("\tIsInherited: " + ace.IsInherited);
				Console.WriteLine("\tPropagationFlags: " + ace.PropagationFlags);

				//NTAccount name = (NTAccount)ace.IdentityReference;
				//Console.WriteLine("\tname: " + name);
                // aby uzyska nieczyteln wersj SID naley zamieni NTAccount na SecurityIdentifier

				Console.WriteLine("-----------------\r\n\r\n");
			}


			foreach (RegistryAuditRule ace in regSec.GetAuditRules(true, true, typeof(NTAccount)))
			{
				Console.WriteLine("\tIdentityReference.Value: " + ace.IdentityReference.Value);
				Console.WriteLine("\tAuditFlags: " + ace.AuditFlags);
				Console.WriteLine("\tRegistryRights: " + ace.RegistryRights.ToString());
				Console.WriteLine("\tInheritanceFlags: " + ace.InheritanceFlags);
				Console.WriteLine("\tIsInherited: " + ace.IsInherited);
				Console.WriteLine("\tPropagationFlags: " + ace.PropagationFlags);

				Console.WriteLine("-----------------\r\n\r\n");
			}

			Console.WriteLine("GetGroup(typeof(NTAccount)).Value: " + regSec.GetGroup(typeof(NTAccount)).Value);
			Console.WriteLine("GetOwner(typeof(NTAccount)).Value: " + regSec.GetOwner(typeof(NTAccount)).Value);

			Console.WriteLine("---------------------------------------\r\n\r\n\r\n");
		}




		public static void DisplayFileSecurityInfo(FileSecurity fileSec)
		{
			Console.WriteLine("GetSecurityDescriptorSddlForm:  " + fileSec.GetSecurityDescriptorSddlForm(AccessControlSections.All));

			foreach (FileSystemAccessRule ace in fileSec.GetAccessRules(true, true, typeof(NTAccount)))
			{
				Console.WriteLine("\tIdentityReference.Value: " + ace.IdentityReference.Value);
				Console.WriteLine("\tAccessControlType: " + ace.AccessControlType);
				Console.WriteLine("\tFileSystemRights: " + ace.FileSystemRights);
				Console.WriteLine("\tInheritanceFlags: " + ace.InheritanceFlags);
				Console.WriteLine("\tIsInherited: " + ace.IsInherited);
				Console.WriteLine("\tPropagationFlags: " + ace.PropagationFlags);

				Console.WriteLine("-----------------\r\n\r\n");
			}


			foreach (FileSystemAuditRule ace in fileSec.GetAuditRules(true, true, typeof(NTAccount)))
			{
				Console.WriteLine("\tIdentityReference.Value: " + ace.IdentityReference.Value);
				Console.WriteLine("\tAuditFlags: " + ace.AuditFlags);
				Console.WriteLine("\tFileSystemRights: " + ace.FileSystemRights);
				Console.WriteLine("\tInheritanceFlags: " + ace.InheritanceFlags);
				Console.WriteLine("\tIsInherited: " + ace.IsInherited);
				Console.WriteLine("\tPropagationFlags: " + ace.PropagationFlags);

				Console.WriteLine("-----------------\r\n\r\n");
			}

			Console.WriteLine("GetGroup(typeof(NTAccount)).Value: " + fileSec.GetGroup(typeof(NTAccount)).Value);
			Console.WriteLine("GetOwner(typeof(NTAccount)).Value: " + fileSec.GetOwner(typeof(NTAccount)).Value);

			Console.WriteLine("---------------------------------------\r\n\r\n\r\n");
		}
		#endregion

        #region 17.14 Nadawanie i odbieranie dostpu do pliku lub klucza rejestru
        // ms-help://MS.VSCC.v80/MS.MSDNQTR.v80.en/MS.MSDN.v80/MS.NETDEVFX.v20.en/cpref/html/M_System_Security_AccessControl_FileSystemSecurity_AddAccessRule_1_609c1893.htm
		// ms-help://MS.VSCC.v80/MS.MSDNQTR.v80.en/MS.MSDN.v80/MS.NETDEVFX.v20.en/cpref/html/O_T_System_IO_File_GetAccessControl.htm
		// ms-help://MS.VSCC.v80/MS.MSDNQTR.v80.en/MS.MSDN.v80/MS.NETDEVFX.v20.en/cpref/html/M_System_IO_File_SetAccessControl_1_8d292e58.htm

		//  http://pluralsight.com/wiki/default.aspx/Keith.GuideBook/HowToProgramWithSIDs.html


		public static void TestGrantRevokeFileRights()
		{
			NTAccount user = new NTAccount("STEIHETW2K\\Debugger Users");

			string file = @"c:\BOOT.INI";
			GrantFileRights(file, user, FileSystemRights.Delete, InheritanceFlags.None, PropagationFlags.None, AccessControlType.Allow);
			RevokeFileRights(file, user, FileSystemRights.Delete, InheritanceFlags.None, PropagationFlags.None, AccessControlType.Allow);

            RegistryKey regKey = Registry.LocalMachine.OpenSubKey(@"SOFTWARE\MojaFirma\MojaAplikacja");
			GrantRegKeyRights(regKey, user, RegistryRights.Notify, InheritanceFlags.None, PropagationFlags.None, AccessControlType.Deny);
			RevokeRegKeyRights(regKey, user, RegistryRights.Notify, InheritanceFlags.None, PropagationFlags.None, AccessControlType.Deny);
		}


        public static void GrantRevokeRegKeyRights( )
        {
            NTAccount user = new NTAccount(@"WRKSTN\ST");
            using (RegistryKey regKey = Registry.LocalMachine.OpenSubKey(@"SOFTWARE\MojaFirma\MojaAplikacja"))
            {
                GrantRegKeyRights(regKey, user, RegistryRights.WriteKey,InheritanceFlags.None, PropagationFlags.None, AccessControlType.Allow);
                RevokeRegKeyRights(regKey, user, RegistryRights.WriteKey, InheritanceFlags.None, PropagationFlags.None, AccessControlType.Allow);
            }
        }

        public static void GrantRegKeyRights(RegistryKey regKey, NTAccount user, RegistryRights rightsFlags, InheritanceFlags inherFlags, PropagationFlags propFlags, AccessControlType actFlags)
		{
			RegistrySecurity regSecurity = regKey.GetAccessControl();

			DisplayRegKeySecurityInfo(regSecurity);

			RegistryAccessRule rule = new RegistryAccessRule(user, rightsFlags, inherFlags, propFlags, actFlags);
			
            regSecurity.AddAccessRule(rule);
			regKey.SetAccessControl(regSecurity);

			DisplayRegKeySecurityInfo(regSecurity);
		}

		public static void RevokeRegKeyRights(RegistryKey regKey, NTAccount user, RegistryRights rightsFlags, InheritanceFlags inherFlags, PropagationFlags propFlags, AccessControlType actFlags)
		{
			RegistrySecurity regSecurity = regKey.GetAccessControl();

			DisplayRegKeySecurityInfo(regSecurity);

			RegistryAccessRule rule = new RegistryAccessRule(user, rightsFlags, inherFlags, propFlags, actFlags);

            regSecurity.RemoveAccessRuleSpecific(rule);

			regKey.SetAccessControl(regSecurity);

			DisplayRegKeySecurityInfo(regSecurity);
		}




		public static void GrantFileRights(string file, NTAccount user, FileSystemRights rightsFlags, InheritanceFlags inherFlags, PropagationFlags propFlags, AccessControlType actFlags)
		{
			FileSecurity fileSecurity = File.GetAccessControl(file);

			DisplayFileSecurityInfo(fileSecurity);

			FileSystemAccessRule rule = new FileSystemAccessRule(user, rightsFlags, inherFlags, propFlags, actFlags);
			fileSecurity.AddAccessRule(rule);
			File.SetAccessControl(file, fileSecurity);

			DisplayFileSecurityInfo(fileSecurity);
		}

		public static void RevokeFileRights(string file, NTAccount user, FileSystemRights rightsFlags, InheritanceFlags inherFlags, PropagationFlags propFlags, AccessControlType actFlags)
		{
			FileSecurity fileSecurity = File.GetAccessControl(file);

			DisplayFileSecurityInfo(fileSecurity);

			FileSystemAccessRule rule = new FileSystemAccessRule(user, rightsFlags, inherFlags, propFlags, actFlags);
			fileSecurity.RemoveAccessRuleSpecific(rule);
			File.SetAccessControl(file, fileSecurity);

			DisplayFileSecurityInfo(fileSecurity);
		}
		#endregion

        #region 17.15 Zabezpieczanie danych w postaci cigw znakw
        public static void TestSecureString()
		{
			StreamReader sr = new StreamReader("data.txt");
			SecureString secretStr = CreateSecureString(sr);

			// nie mona zmodyfikowa cigu znakw:  secretStr.AppendChar('x');

			// aby mc z powrotem odczyta cig znakw, naley uy odpowiednich metod
			IntPtr secretStrPtr = Marshal.SecureStringToBSTR(secretStr);
			string nonSecureStr = Marshal.PtrToStringBSTR(secretStrPtr);

			Console.WriteLine("Zabezpieczony cig znakw = " + secretStr.ToString());
            Console.WriteLine("Cig znakw bez zabezpieczenia = " + nonSecureStr);
		}

		public static SecureString CreateSecureString(StreamReader secretStream)
		{
			SecureString secretStr = new SecureString();
			char buf;

			while (secretStream.Peek() >= 0)
			{
				buf = (char)secretStream.Read();
				secretStr.AppendChar(buf);
			}

			// cig znakw bdzie tylko do odczytu
			secretStr.MakeReadOnly();

			return (secretStr);
		}

        public static void ReadSecureString(SecureString secretStr)
        {
            // aby mc z powrotem odczyta cig znakw, naley uy odpowiednich metod
            IntPtr secretStrPtr = Marshal.SecureStringToBSTR(secretStr);
            string nonSecureStr = Marshal.PtrToStringBSTR(secretStrPtr);
            
            // uycie niezabezpieczonego cigu znakw
            Console.WriteLine("Cig znakw bez zabezpieczenia = {0}", nonSecureStr);
            
            Marshal.ZeroFreeBSTR(secretStrPtr);
            
            if (!secretStr.IsReadOnly())
            {
                secretStr.Clear();
            }
        }

		#endregion        

        #region 17.16 Zabezpieczanie strumienia danych (patrz AuthenticatedStream, NegotiateStream i SslStream)"
        // ms-help://MS.VSCC.v80/MS.MSDNQTR.v80.en/MS.MSDN.v80/MS.NETDEVFX.v20.en/cpref/html/T_System_Net_Security_SslStream.htm

		//http://www.leastprivilege.com/CategoryView.aspx?category=Samples
		//http://www.devnewsgroups.net/group/microsoft.public.dotnet.framework/topic11749.aspx
		//      http://www.devnewsgroups.net/link.aspx?url=http://blogs.msdn.com/jhoward/archive/2005/02/02/365323.aspx
		//      http://msdn.microsoft.com/library/default.asp?url=/library/en-us/cptools/html/cpgrfcertificatecreationtoolmakecertexe.asp
		//      http://www.inventec.ch/chdh/notes/14.htm
		#endregion

        #region 17.17 Szyfrowanie danych w pliku web.config

        public static void EncryptWebConfigData(string appPath,string protectedSection,string dataProtectionProvider)
        {
            System.Configuration.Configuration webConfig =
            WebConfigurationManager.OpenWebConfiguration(appPath);
            ConfigurationSection webConfigSection = webConfig.GetSection(protectedSection);
            if (!webConfigSection.SectionInformation.IsProtected)
            {
                webConfigSection.SectionInformation.ProtectSection(dataProtectionProvider);
                webConfig.Save();
            }
        }

        public static void DecryptWebConfigData(string appPath, string protectedSection)
        {
            System.Configuration.Configuration webConfig =
            WebConfigurationManager.OpenWebConfiguration(appPath);
            ConfigurationSection webConfigSection = webConfig.GetSection(protectedSection);
            if (webConfigSection.SectionInformation.IsProtected)
            {
                webConfigSection.SectionInformation.UnprotectSection();
                webConfig.Save();
            }
        }
        #endregion

        #region 17.20 Rozpoznawanie penej przyczyny wyrzucenia wyjtku SecurityException (nowe waciwoci klasy SecurityException)
        // ms-help://MS.VSCC.v80/MS.MSDNQTR.v80.en/MS.MSDN.v80/MS.NETDEVFX.v20.en/cpref/html/T_System_Security_SecurityException.htm

		//http://blogs.msdn.com/shawnfa/archive/2004/07/30/202468.aspx
		//http://blog.hundhausen.com/ASPNET+20+SecurityException.aspx


		public static void TestSecurityException()
		{
			RunCode();
			Console.WriteLine("Nacinij ENTER, aby wyj.");
			Console.Read();
		}

		public static void RunCode()
		{
			try
			{
				// odebranie uprawnienia
				RegistryPermission regPerm = new RegistryPermission(RegistryPermissionAccess.Read, "HKEY_LOCAL_MACHINE\\Software\\MyApp");
				regPerm.Deny();

				// zadanie odebranego uprawnienia i wywietlenie waciwoci wyjtku
				Display("danie odebranego uprawnienia. \n\n");
				DemandDeniedPermission();
				Display("************************************************\n");
				CodeAccessPermission.RevertDeny();

				// zadanie uprawnienia, ktrego odmwiono na poziomie atrybutu podzespouDemand the permission refused in the 
				Display("danie uprawnienia, ktrego odmwiono. \n\n");
				DemandRefusedPermission();
				Display("************************************************\n");

				// Zadanie uprawnienia, ktrego niejawnie odmwiono
                // za porednictwem atrybutu PermitOnly. Udostpnienie wycznie uprawnienia,
                // ktre spowoduje bd, a take uprawnie bezpieczestwa niezbdnych
                // wywietlenia wynikw bdu.
				PermissionSet permitOnly = new PermissionSet(PermissionState.None);
				permitOnly.AddPermission(new KeyContainerPermission(KeyContainerPermissionFlags.Import));
				permitOnly.AddPermission(new SecurityPermission(SecurityPermissionFlag.ControlEvidence |
					SecurityPermissionFlag.ControlPolicy |
					SecurityPermissionFlag.SerializationFormatter));
				permitOnly.PermitOnly();
				Display("danie uprawnienia odmwionego niejawnie. \n\n");
				DemandPermitOnly();
			}
			catch (Exception sE)
			{
				Display("************************************************\n");
				Display("Wywietlenie wyjtku przy uyciu metody ToString: ");
				Display(sE.ToString());
			}
		}

		public static void DemandDeniedPermission()
		{
			try
			{
				RegistryPermission regPerm = new RegistryPermission(RegistryPermissionAccess.Read, "HKEY_LOCAL_MACHINE\\Software\\MojaAplikacja");
				regPerm.Demand();
			}
			catch (SecurityException sE)
			{
				Display("Odebrane uprawnienie: " + ((PermissionSet)sE.DenySetInstance).ToString());
				Display("Zadane uprawnienie: " + sE.Demanded.ToString());
				Display("Czynno systemu zabezpiecze: " + sE.Action.ToString());
				Display("Metoda: " + sE.Method);
				Display("Stan uprawnienia w momencie pojawienia si wyjtku: " + sE.PermissionState);
				Display("Uprawnienie, ktre spowodowao bd: " + (IPermission)sE.FirstPermissionThatFailed);
				Display("Typ uprawnienia: " + sE.PermissionType.ToString());
				Display("Sposb uycia metody GetObjectData.");
				SerializationInfo si = new SerializationInfo(typeof(Security), new FormatterConverter());
				sE.GetObjectData(si, new StreamingContext(StreamingContextStates.All));
				Display("Pierwsze uprawnienie z wywoania GetObjectData, ktre spowodowao bd: ");
				Display(si.GetString("FirstPermissionThatFailed"));
			}
		}

		public static void DemandRefusedPermission()
		{
			try
			{
				RegistryPermission regPerm = new RegistryPermission(RegistryPermissionAccess.Read, "HKEY_LOCAL_MACHINE\\Software\\MyApp");
				regPerm.Demand();
			}
			catch (SecurityException sE)
			{
				Display("Zestaw uprawnie, ktrego odmwiono: " + (sE.RefusedSet).ToString());
				Display("Komunikat wyjtku: " + sE.Message);
				Display("Podzesp, w ktrym wystpi bd: " + sE.FailedAssemblyInfo.EscapedCodeBase);
				Display("Przyznany zestaw uprawnie: \n" + sE.GrantedSet);
				Display("Uprawnienie, ktre zakoczyo si bdem: " + sE.FirstPermissionThatFailed);
				Display("Typ uprawnienia: " + sE.PermissionType.ToString());
				Display("rdo: " + sE.Source);
			}
		}

		public static void DemandPermitOnly()
		{
			try
			{
				RegistryPermission regPerm = new RegistryPermission(RegistryPermissionAccess.Read, "HKEY_LOCAL_MACHINE\\Software\\MyApp");
				regPerm.Demand();
			}
			catch (SecurityException sE)
			{
				Display("Przydzielone uprawnienie: " + ((PermissionSet)sE.PermitOnlySetInstance).ToString());
				Display("dane uprawnienie: " + sE.Demanded.ToString());
                Display("Czynno systemu zabezpiecze: " + sE.Action.ToString());
                Display("Metoda: " + sE.Method.ToString());
                Display("Stan uprawnienia w momencie pojawienia si wyjtku: " + sE.PermissionState);
                Display("Uprawnienie, ktre spowodowao bd: " + (IPermission)sE.FirstPermissionThatFailed);
                Display("Typ uprawnienia: " + sE.PermissionType.ToString());

				// prezentacja konstruktora SecurityException 
                // przez ponowne wyrzucenie wyjtku
				Display("Ponowne wyrzucenie wyjtku jako wynik czynnoci PermitOnly systemu zabezpiecze.");
				throw new SecurityException(sE.Message, sE.DenySetInstance, sE.PermitOnlySetInstance,
											sE.Method, sE.Demanded, (IPermission)sE.FirstPermissionThatFailed);
			}
		}
		public static void Display(string line)
		{
			Console.WriteLine(line);
		}
		#endregion

        #region 17.21 Zabezpieczanie procesu kodowania Unicode
        
        public static void TestUnicodeEncodingWithSecurity()
		{
			byte[] SourceArray2 = {128, 0, 83, 0, 111, 0, 117, 0, 114, 0, 99, 0, 
			                       101, 0, 32, 0, 83, 0, 116, 0, 114, 0, 105, 0, 
                                   110, 0, 103, 0, 128, 0};

			Console.WriteLine("\r\nWywoywanie FromUnicodeByteArray...");
			Console.WriteLine(FromUnicodeByteArray(SourceArray2));

			Console.WriteLine("\r\nWywoywanie ToUnicodeByteArray...");
			string SourceStr = "rdowy cig znakw";
			foreach (byte b in ToUnicodeByteArray(SourceStr))
				Console.WriteLine(b);

			Console.WriteLine();
		}


		// z receptury 2.13
		public static string FromUnicodeByteArray(byte[] characters)
		{
			UnicodeEncoding encoding = new UnicodeEncoding(false, true, true);
			string constructedString = encoding.GetString(characters);

			return (constructedString);
		}

		// z receptury 2.14
		public static byte[] ToUnicodeByteArray(string characters)
		{
			UnicodeEncoding encoding = new UnicodeEncoding(false, true, true);
			int numberOfChars = encoding.GetByteCount(characters);
			byte[] retArray = new byte[numberOfChars];

			retArray = encoding.GetBytes(characters);

			return (retArray);
		}
		#endregion

		#region "*   17.22 Using SafeHandle"
		//ms-help://MS.VSCC.v80/MS.MSDNQTR.v80.en/MS.MSDN.v80/MS.NETDEVFX.v20.en/cpref/html/T_System_Runtime_InteropServices_SafeHandle.htm
		#endregion
	}
}
